* Encoding: UTF-8.

*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Clculo: PARTICIPACIN DE EXPORTACIONES E IMPORTACIONES SEGN FUENTE DE INFORMACIN*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2018 - Transporte Martimo*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        11 de Diciembre del 2018*
* Fecha ltima modificacin:  05 de Septiembre del 2019*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.
* Franklin Tenesaca N.
* Gabriela Hidalgo.

*Instrucciones:.
*1.- Descarga la base de datos de Transporte Martimo "2018_Transporte Martimo_BDD" en formato SPSS de la pgina web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2018_Transporte Martimo_BDD".

DATASET NAME MARITIMO.
DATASET COPY MARITIMO.
DATASET ACTIVATE MARITIMO.

**********************************************************************************************************************.
**************PARTICIPACIN DE LAS IMPORTACIONES VA MARTIMA EN RELACIN***************.
*********************************AL TOTAL DE IMPORTACIONES**********************************************.
**********************************************************************************************************************.

***Para calcular la proporcin solo se considerar la Carga Entrada y Salida de las Autoridades Portuarias***.
SELECT IF (PUERTO='APE' | PUERTO='APM' | PUERTO='APG' | PUERTO='APPB' | PUERTO='SUINBA'| PUERTO='SUINLI' | PUERTO='SUINSA').
EXECUTE.

***Agregando la base de datos por mes de entrada***.

DATASET DECLARE CARGA_1.
AGGREGATE
  /outfile='CARGA_1'
  /break=MES_ENTRADA
  /TIMPOR=SUM(ETC).

DATASET ACTIVATE CARGA_1.

VARIABLE LABELS TIMPOR 'Total Carga Entrada Va Martima'.
VARIABLE LEVEL TIMPOR (SCALE).
EXECUTE.

RENAME VARIABLES MES_ENTRADA=MES.


IF (MES=1) IMPORTACIONES_BCE=1509169.
IF (MES=2) IMPORTACIONES_BCE=1230516.
IF (MES=3) IMPORTACIONES_BCE=1327913.
IF (MES=4) IMPORTACIONES_BCE=1562530.
IF (MES=5) IMPORTACIONES_BCE=1430619.
IF (MES=6) IMPORTACIONES_BCE=1336122.
IF (MES=7) IMPORTACIONES_BCE=1561146.
IF (MES=8) IMPORTACIONES_BCE=1289051.
IF (MES=9) IMPORTACIONES_BCE=1385475. 
IF (MES=10) IMPORTACIONES_BCE=1665959.
IF (MES=11) IMPORTACIONES_BCE=1367849.
IF (MES=12) IMPORTACIONES_BCE=1339098.
EXECUTE.

VARIABLE LABELS IMPORTACIONES_BCE 'Total de importaciones - BCE'.
FORMATS IMPORTACIONES_BCE (F10.2).
EXECUTE.

SORT CASES BY MES (A).


**********************************************************************************************************************.
**************PARTICIPACIN DE LAS EXPORTACIONES VA MARTIMA EN RELACIN***************.
*********************************AL TOTAL DE EXPORTACIONES**********************************************.
**********************************************************************************************************************.

DATASET ACTIVATE MARITIMO.

***Agregando la base de datos por mes de entrada***.

DATASET DECLARE CARGA_2.
AGGREGATE
  /outfile='CARGA_2'
  /break=MES_SALIDA
  /TEXPORT=SUM(STC).

DATASET ACTIVATE CARGA_2.

VARIABLE LABELS TEXPORT 'Total Carga Salida Va Martima'.
VARIABLE LEVEL TEXPORT (SCALE).
EXECUTE.

RENAME VARIABLES MES_SALIDA=MES.

IF (MES=1) EXPORTACIONES_BCE=2772160.
IF (MES=2) EXPORTACIONES_BCE=2226919.
IF (MES=3) EXPORTACIONES_BCE=2703048.
IF (MES=4) EXPORTACIONES_BCE=2507414.
IF (MES=5) EXPORTACIONES_BCE=2734651.
IF (MES=6) EXPORTACIONES_BCE=2456927.
IF (MES=7) EXPORTACIONES_BCE=2617650.
IF (MES=8) EXPORTACIONES_BCE=2691716.
IF (MES=9) EXPORTACIONES_BCE=2575436. 
IF (MES=10) EXPORTACIONES_BCE=2602994.
IF (MES=11) EXPORTACIONES_BCE=2463337.
IF (MES=12) EXPORTACIONES_BCE=2730741. 
EXECUTE. 
 
VARIABLE LABELS EXPORTACIONES_BCE 'Total de exportaciones - BCE'.
FORMATS EXPORTACIONES_BCE (F10.2).
EXECUTE.

SORT CASES BY MES (A).


******UNIENDO BASE DE EXPORTACIONES E IMPORTACIONES********.

DATASET ACTIVATE CARGA_1.
MATCH FILES /FILE=*
  /FILE='CARGA_2'
  /BY MES.
EXECUTE.

COMPUTE PEXPORT= (TEXPORT/EXPORTACIONES_BCE)*100.
FORMATS PEXPORT (F8.2).
VARIABLE LABELS PEXPORT 'Participacin de las exportaciones transportadas por va martima frente al total de exportaciones nacionales (%)'.
EXECUTE.

COMPUTE PIMPORT= (TIMPOR/IMPORTACIONES_BCE)*100.
FORMATS PIMPORT (F8.2).
VARIABLE LABELS PIMPORT 'Participacin de las importaciones transportadas por va martima frente al total de importaciones nacionales (%)'.
EXECUTE.

***CUADRO N 65***.

****POR MES****.

TABLES
/OBSERVATION= EXPORTACIONES_BCE IMPORTACIONES_BCE TEXPORT TIMPOR PEXPORT PIMPORT
/TABLE=MES BY EXPORTACIONES_BCE + IMPORTACIONES_BCE + TEXPORT + TIMPOR + PEXPORT + PIMPORT
/STATISTICS=SUM
/TITLE='CUADRO N 65'
            'TRANSPORTE MARTIMO Y FLUVIAL: PARTICIPACIN DE EXPORTACIONES E IMPORTACIONES SEGN FUENTE DE INFORMACIN, ao 2018'
            'POR MES'
            '(TONELADAS Y PORCENTAJES)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Banco Central del Ecuador- Estadsticas de Comercio Exterior de Bienes' 
                 'INEC- Anuario de Estadsticas de Transporte 2018-Puertos y Superintendencias Petroleras'. 	


***DATO NACIONAL****.

DATASET ACTIVATE CARGA_1.

COMPUTE TOTAL=1.
VALUE LABELS TOTAL 1 'NACIONAL'.
VARIABLE LABELS TOTAL 'TOTAL'.
FORMATS TOTAL (F1.0).
EXECUTE.

DATASET DECLARE NACIONAL.
AGGREGATE
  /outfile='NACIONAL'
  /break=TOTAL
  /EXPORTACIONES_BCE=SUM(EXPORTACIONES_BCE)
  /IMPORTACIONES_BCE=SUM(IMPORTACIONES_BCE)
  /TEXPORT=SUM(TEXPORT)
  /TIMPOR=SUM(TIMPOR).

DATASET ACTIVATE NACIONAL.

VARIABLE LABELS EXPORTACIONES_BCE 'Total de exportaciones - BCE'.
FORMATS EXPORTACIONES_BCE (F10.2).
EXECUTE.

VARIABLE LABELS IMPORTACIONES_BCE 'Total de importaciones - BCE'.
FORMATS IMPORTACIONES_BCE (F10.2).
EXECUTE.

VARIABLE LABELS TEXPORT 'Total Carga Salida Va Martima'.
VARIABLE LEVEL TEXPORT (SCALE).
EXECUTE.

VARIABLE LABELS TIMPOR 'Total Carga Entrada Va Martima'.
VARIABLE LEVEL TIMPOR (SCALE).
EXECUTE.

COMPUTE PEXPORT= (TEXPORT/EXPORTACIONES_BCE)*100.
FORMATS PEXPORT (F8.2).
VARIABLE LABELS PEXPORT 'Participacin de las exportaciones transportadas por va martima frente al total de exportaciones nacionales (%)'.
EXECUTE.

COMPUTE PIMPORT= (TIMPOR/IMPORTACIONES_BCE)*100.
FORMATS PIMPORT (F8.2).
VARIABLE LABELS PIMPORT 'Participacin de las importaciones transportadas por va martima frente al total de importaciones nacionales (%)'.
EXECUTE.

TABLES
/OBSERVATION= EXPORTACIONES_BCE IMPORTACIONES_BCE TEXPORT TIMPOR PEXPORT PIMPORT
/TABLE=TOTAL BY EXPORTACIONES_BCE + IMPORTACIONES_BCE + TEXPORT + TIMPOR + PEXPORT + PIMPORT
/STATISTICS=SUM
/TITLE='CUADRO N 65'
            'TRANSPORTE MARTIMO Y FLUVIAL: PARTICIPACIN DE EXPORTACIONES E IMPORTACIONES SEGN FUENTE DE INFORMACIN, ao 2018'
            'POR MES'
            '(TONELADAS Y PORCENTAJES)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Banco Central del Ecuador- Estadsticas de Comercio Exterior de Bienes' 
                 'INEC- Anuario de Estadsticas de Transporte 2018-Puertos y Superintendencias Petroleras'. 


DATASET ACTIVATE MARITIMO.
DATASET CLOSE CARGA_2.
DATASET ACTIVATE MARITIMO.
DATASET CLOSE CARGA_1.
DATASET ACTIVATE MARITIMO.
DATASET CLOSE NACIONAL.




